/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.explorer.internal.ui;

import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoryManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

class GitChangedFilesFilter
extends ViewerFilter {
    GitChangedFilesFilter() {
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IResource resource = null;
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            resource = (IResource)adaptable.getAdapter(IResource.class);
        }
        if (resource != null) {
            return this.isChanged(resource);
        }
        return false;
    }

    private boolean isChanged(IResource resource) {
        GitRepository repo = this.getGitRepositoryManager().getAttached(resource.getProject());
        if (repo == null) {
            return false;
        }
        return repo.resourceOrChildHasChanges(resource);
    }

    private IGitRepositoryManager getGitRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }
}

